// i18n.js
var currentPort

window.addEventListener("message", (event) => {
    // alert(event.data)
    if (event.data === "trans_port") {
        currentPort = event.ports[0]
        if (currentPort) {
           currentPort.postMessage('ok')
           currentPort.onmessage = (event) => {
               currentPort.postMessage("HTML接收信息成功：" + event.data)
               // document.querySelector("#test").innerText = event.data
               // 加载语言文本
               loadLanguage(event.data)
           }
        }
    }
})

function loadLanguage(lang) {
    if (lang === 'zh-Hans-CN') {
        lang = 'zh-Hans'
    } else if (lang === 'en-Latn-US') {
        lang = 'en-Latn'
    } else if (lang === 'zh-Hant-HK') {
        lang = 'zh-HK'
    } else if (lang === 'zh-Hant-TW') {
        lang = 'zh-TW'
    }
    currentPort.postMessage(`loadLanguage开始运行: ${lang}`)
    document.querySelectorAll('[data-i18n]').forEach(element => {
        const key = element.getAttribute('data-i18n');
        element.textContent = translations[lang][key];
    });
}


const translations = {
    'zh-Hans': {
     //   "u-main-title": "用户协议",
        "u-sub-title": "更新日期：2025年5月1日",
        "u-sub-title-2": "ClashNEXT的所有权和运作权归小白工坊所有。在本服务条款中简称\"本工坊\"或称为\"我们\"。使用ClashNEXT产品及服务将视为您同意以下使用条款。",
        "u-h2-1": "1. 仅供个人使用",
        "u-p-1": "ClashNEXT仅供用户个人用于学习交流、科研等非商业用途。禁止私自将ClashNEXT或与ClashNEXT有关或派生的任何资料、服务或软件用于商业目的。如果用户对ClashNEXT有任何意见，或有如何改进的建议，可向我们提出。请注意，如果这样做，还会授予ClashNEXT和第三方在ClashNEXT（或第三方软件）中无偿使用和加入用户的建议或意见的权利。",
        "u-h2-2": "2. 知识产权",
        "u-p-2": "用户承认本团队拥有对ClashNEXT的所有权利，包括但不限于所有知识产权。\"知识产权\"指在专利法、版权法、商业机密法、商标法、反不正当竞争法等法中规定的所有权利以及其中的所有应用、更新、扩展和恢复，无论在现在还是以后在全球范围内实施和生效。用户同意不会通过反编译、反向工程、反汇编等方式从ClashNEXT得到源代码。用户可以通过ClashNEXT开源仓库获取核心源代码，并同意不会删除、掩盖或更改本团队或任何第三方的版权声明、商标或其它所有权声明。",
        "u-h2-3": "3. 用户隐私制度",
        "u-p-3-1": "尊重用户个人隐私是本团队的一项基本政策。所以，本团队一般不会公开、编辑或透露用户的注册资料或保存在本团队服务中的非公开内容，除非本团队在诚信的基础上认为透露这些信息在以下几种情况是必要的：",
        "u-3-li-1": "遵守有关法律规定，包括在国家有关机关查询时，提供用户通过ClashNEXT发布的信息内容及其发布时间、互联网地址或者域名。遵从ClashNEXT的服务程序。",
        "u-3-li-2": "保持维护本团队的商标等知识产权。",
        "u-3-li-3": "在紧急情况下竭力维护用户个人和社会大众的隐私安全。",
        "u-3-li-4": "本团队认为必要的其他情况下。",
        "u-p-3-2": "该政策解释了当您使用ClashNEXT的相关的服务时，ClashNEXT会如何处理您的个人信息，以及如何保护您的隐私权。您同意会在遵守ClashNEXT隐私权政策的前提下应用自己的数据。",
        "u-h2-4": "4. 服务变更",
        "u-p-4": "本团队保留随时变更、中断或终止服务而不需通知用户的权利。用户接受本团队行使变更、中断或终止服务的权利，本团队不需对用户或第三方负责。",
        "u-h2-5": "5. 责任限制",
        "u-p-5-1": "用户理解并同意自主选择下载和使用ClashNEXT和所有与ClashNEXT一同提供或通过ClashNEXT提供的第三方软件，风险自负，并且对于因下载或使用ClashNEXT和此类第三方软件而对计算机系统造成的损坏或数据的丢失，用户应承担全部责任。在适用法律允许的最大范围内，本团队明确表示不提供任何其他类型的保证，不论使明示的或默示的，包括但不限于适销性、适用性、可靠性、准确性、完整性、无病毒以及无错误的任何默示保证和责任。",
        "u-p-5-2": "在适用法律允许的最大范围内，本团队及其许可人不会向您做出以下声明或担保：",
        "u-li-5-1": "您对服务的使用会满足您的需求；",
        "u-li-5-2": "您对服务的使用会连续无中断、及时、安全或没有错误；",
        "u-li-5-3": "您使用相关服务而获得的任何信息一律准确可靠；",
        "u-p-5-3": "作为相关服务的一部分向您提供的任何软件所发生的操作或功能瑕疵将获得修正。",
        "u-p-5-4": "在适用法律允许的最大范围内，本团队不就因用户使用ClashNEXT引起的，或在任何方面与本团队的产品和服务有关的任何意外的、非直接的、特殊的、或间接的损害或请求（包括但不限于因人身伤害、因隐私泄漏、因未能履行包括诚信或合理谨慎在内的任何责任、因过失和因任何其他金钱上的损失或其他损失而造成的损害赔偿）承担任何责任。",
        "u-h2-6": "6. 保障",
        "u-p-6": "用户同意保障和维护本团队的利益，负责支付由用户违反本服务条款或本团队其他服务条款而引起的律师费用、损害补偿费用、政府机关处罚费用和其它侵权赔偿费用等。",
        "u-h2-7": "7. 法律",
        "u-p-7-1": "上述条款将受中华人民共和国法律的约束并依据其解释。如出现纠纷，用户和本团队一致同意将纠纷交由当地人民法院管辖。如用户对本服务条款内容有任何疑问，通过以下方式联系我们：",
        "u-p-7-2": "发送邮件到：",
        "u-p-7-3": "xfz347@gmail.com",
        "u-p-7-4": "加入QQ交流群：",
        "u-p-7-5": "693903194",
        "u-h2-8": "开发者：小白工坊",
        "u-h2-9": "应用名称：ClashNEXT",
     //   "p-main-title": "关于ClashNEXT与隐私的声明",
        "p-sub-title": "更新日期：2025年5月11日",
        "p-sub-title-1": "本政策仅适用于本工坊（以下简称「我们」）的产品「ClashNEXT」及其相关服务。",
        "p-sub-title-2": "您的个人信息安全对我们来说至关重要，一直以来，我们都尽全力保护您的个人信息安全，致力于维持您对我们的信任。我们将依据相关法律法规和技术规范收集和使用您的个人信息，以帮助我们向您提供更优质的产品和服务。同时，我们承诺会对您的个人信息和其他数据进行严格保密，确保您的个人信息安全。",
        "p-sub-title-3": "请在使用我们的产品和服务前，仔细阅读本隐私政策（以下简称「本政策」）。一旦您开始使用「ClashNEXT产品及相关服务，即表示您同意本政策。",
        "p-h2-1": "1. 我们如何收集和使用您的个人信息",
        "p-p-1-1": "我们会遵循正当、合法、必要的原则，基于以下功能和服务，收集和使用您在使用产品（或服务）过程中自愿提供的个人信息。",
        "p-p-1-2": "本应用无法做到也不会额外收集您的个人信息",
        "p-h3-1": "1.1 账号",
        "p-p-1-3": "账号\"指您在使用ClashNEXT APP时将来可能会需要的账号。当您登录时，基于我们与华为的合作，我们会收集您的【华为账户】，以便为您提供快捷的登录服务。",
        "p-p-1-4": "我们遵循数据最小化原则，仅获取【华为账户】中必要的用户昵称、头像、UnionID和OpenID，用于展示、发放VIP权益及云备份服务，全程不会接触或收集用户的手机号等敏感个人信息，切实保障用户账号信息安全。",
        "p-p-1-5": "用户可在不登陆的状态下正常使用本应用的所有免费基础功能。在该状态下，所有用户数据将仅存储在设备本地，由用户自行管理。",
        "p-h3-2": "1.2 同步任务数据",
        "p-p-2-1": "一旦您可以注册账户并在账户中创建设置等数据，且需要使用同步服务时，为使您正常、完整地在各设备间同步数据，您需要允许我们收集您的应用设置、代理配置、覆写设置、您进行编辑操作的设备信息（包括：设备型号、操作系统版本，唯一设备标识符、设备显示状态）以上信息仅用于您在各设备间同步数据，我们不会也无法读取您的数据内容。",
        "p-h3-3": "1.3 提交反馈",
        "p-p-3-1": "您向ClashNEXT发送提交反馈时，为确保我们能准确理解并筛宣您遇到的问题，我们可能会收集的信息包括：Log files、设备型号、操作系统版本。",
        "p-h3-4": "1.4 应用内会申请的权限",
        "p-p-4-1": "我们需要申请部分涉及个人隐私的系统权限，确保应用内某些功能可以正常使用。我们会在您使用这些功能时，向您申请授权，明确获得您的授权后，我们才会访问您的个人信息。若您不需要使用这些功能，可以拒绝授权；若您从未使用过这些功能，我们不会向您申请权限、也不会访问您的个人信息。我们会申请的权限及这些权限对应的功能包括：",
        "p-p-4-2": "允许相机权限：当您需要通过拍摄照片或扫描二维码导入配置时，我们会申请此权限。获得授权后，您可以使用相机功能添加图片至待办事项或快速扫码；",
        "p-p-4-3": "允许多设备协同权限：当应用可以实现且您需要同步设备间数据时，我们会申请此权限；",
        "p-p-4-4": "允许通知权限：当您需要后台运行任务时，我们会申请此权限。",
        "p-h3-5": "1.5 其他用途说明",
        "p-p-5-1": "当我们需要将您的信息用于本政策未说明的其他用途时，会提前征求您的同意。当我们需要将基于特定目的收集来的信息用于其他目的时，会提前征求您的同意。",
        "p-h2-2": "2. 您管理个人信息的权利",
        "p-p-2-2": "我们尽全力保护您对于自己个人信息访问、更正以及删除的权利，以使您拥有充分的能力保障您的隐私和安全。",
        "p-h2-3": "3. 对儿童的保护",
        "p-p-3-2": "我们的产品和服务仅面向成人。",
        "p-h2-4": "4. 第三方SDK",
        "p-p-4-5": "我们会对 SDK 或其他类似的应用程序进行严格的安全检测，并要求合作伙伴采取严格的措施来保护您的个人数据。在满足新的服务需求及业务功能变更时，我们可能会调整我们接入的第三方 SDK，并及时在本说明中向您公开说明接入第三方 SDK 的最新情况。请注意，第三方SDK 可能因为版本升级、策略调整等原因导致数据类型存在一些变化，请以其公示的官方说明为准。本应用已接入的第三方SDK请前往三方库与服务中查看。",
        "p-h2-5": "5. 本政策如何更新",
        "p-p-5-2": "由于本隐私政策可能不定时更新，您应定期查看以了解我们保护所收集之个人信息的方案及程序。您继续使用ClashNEXT服务即构 成您对本隐私政策及其任何更新版本的同意。对于重大变更，视具体情况我们可能还会提供更为显著的通知说明本政策的具体变更内容。重大变更包括但不限于：",
        "p-p-5-3": "我们的服务模式发生重大变化。如申请收集个人信息等；",
        "p-p-5-4": "您参与个人信息处理方面的权利及其行使方式发生重大变化；",
        "p-p-5-5": "个人信息安全影响评估报告表明存在高风险时。",
        "p-p-5-6": "我们负责处理反馈信息的责任部门、联络方式及投诉渠道发生变化时；",
        "p-h2-6": "6. 如何联系我们",
        "p-p-6-1": "如果您对本隐私政策有任何疑问、意见或建议，通过以下方式联系我们：",
        "p-p-6-2": "发送邮件到：",
        "p-p-6-3": "xfz347@gmail.com",
        "p-p-6-4": "加入QQ交流群：",
        "p-p-6-5": "693903194",
        "p-h2-7": "开发者：小白工坊",
        "p-h2-8": "应用名称：ClashNEXT"
    },
    'en-Latn': {
      //  "u-main-title": "User Agreement",
        "u-sub-title": "Last Updated: May 1, 2025",
        "u-sub-title-2": "All ownership and operational rights of ClashNEXT belong to Xiaobai Studio. In this Service Agreement, referred to as \"the Studio\" or \"We\". Use of ClashNEXT products and services constitutes acceptance of the following terms.",
        "u-h2-1": "1. Intended for Personal Use Only",
        "u-p-1": "ClashNEXT is provided solely for users' personal use in learning, exchange, research and other non-commercial purposes. Unauthorized commercial use of ClashNEXT or any related materials, services, or software derived from ClashNEXT is strictly prohibited. Users may submit suggestions for improvement. Please note that doing so grants ClashNEXT and third parties the right to use and incorporate such suggestions or opinions in ClashNEXT (or third-party software) free of charge.",
        "u-h2-2": "2. Intellectual Property",
        "u-p-2": "The user acknowledges that the team has all rights to the ClashNEXT, including but not limited to all intellectual property rights. \"Intellectual property\" refers to all rights stipulated in the patent law, copyright law, trade secrets law, trademark law, anti unfair competition law and other laws, as well as all applications, updates, extensions and recoveries thereof, whether implemented and effective globally now or in the future. The user agrees not to get the source code from the Clashbox through decompilation, reverse engineering, disassembly, etc. Users can obtain the core source code through the open source warehouse of the ClashNEXT, and agree not to delete, mask or change the copyright, trademark or other ownership statements of the team or any third party.",
        "u-h2-3": "3. Privacy Policy",
        "u-p-3-1": "Respecting user privacy is a fundamental policy of the Team. Therefore, the Team generally will not disclose, edit, or reveal user registration information or non-public content stored through our services, unless the Team reasonably believes disclosure is necessary in the following circumstances:",
        "u-3-li-1": "Compliance with legal requirements, including providing user-published content through ClashNEXT and relevant metadata to government authorities upon request.",
        "u-3-li-2": "Protection of the Team's trademarks and other intellectual property.",
        "u-3-li-3": "Emergency situations requiring protection of user and public privacy safety.",
        "u-3-li-4": "Other situations deemed necessary by the Team.",
        "u-p-3-2": "This policy explains how we handle personal information when you use ClashNEXT-related services, and how we protect your privacy rights. You agree to comply with our Privacy Policy when using your data.",
        "u-h2-4": "4. Service Modifications",
        "u-p-4": "The Team reserves the right to modify, suspend, or terminate services at any time without prior notice. Users acknowledge and agree that the Team's exercise of these rights shall not constitute a breach of this Agreement or liability to users or third parties.",
        "u-h2-5": "5. Limitation of Liability",
        "u-p-5-1": "Users understand and agree to assume full responsibility for downloading and using ClashNEXT and any third-party software provided through ClashNEXT. Users shall bear all risks and damages resulting from system failures or data loss caused by such actions.",
        "u-p-5-2": "To the maximum extent permitted by law, the Team expressly disclaims all other warranties, whether express or implied, including but not limited to:",
        "u-li-5-1": "The service will meet your needs;",
        "u-li-5-2": "The service will be uninterrupted, timely, secure, or error-free;",
        "u-li-5-3": "Information obtained through the service is accurate and reliable;",
        "u-p-5-3": "Any software provided as part of the service will be free from operational or functional defects.",
        "u-p-5-4": "To the maximum extent permitted by law, the Team shall not be liable for any indirect, special, or consequential damages (including but not limited to personal injury, privacy breaches, failure to perform obligations including due care, negligence, or any financial losses) arising from the use of ClashNEXT or related services.",
        "u-h2-6": "6. Indemnification",
        "u-p-6": "Users agree to indemnify and hold harmless the Team from any claims, damages, or expenses (including legal fees) arising from user violations of this Agreement or other Team policies.",
        "u-h2-7": "7. Governing Law",
        "u-p-7-1": "This Agreement shall be governed by and construed in accordance with the laws of the People's Republic of China. Any disputes shall be subject to the jurisdiction of the local courts in the relevant area. For any questions regarding this Agreement, contact us through:",
        "u-p-7-2": "Email: xfz347@gmail.com",
        "u-p-7-3": "QQ Group: 693903194",
        "u-h2-8": "Developer: Xiaobai Studio",
        "u-h2-9": "App Name: ClashNEXT",
     //   "p-main-title": "Statement on ClashNEXT and Privacy",
        "p-sub-title": "Updated: May 11, 2025",
        "p-sub-title-1": "This policy applies only to our product \"ClashNEXT\" and its related services provided by our company (hereinafter referred to as \"we\").",
        "p-sub-title-2": "Your personal information security is of utmost importance to us. We always strive to protect your personal information and maintain your trust. We collect and use your personal information in accordance with relevant laws, regulations, and technical specifications to help us provide you with better products and services. We are committed to strictly safeguarding your personal information and other data to ensure its security.",
        "p-sub-title-3": "Please read this Privacy Policy (hereinafter referred to as \"this Policy\") carefully before using our products and services. By using ClashNEXT products and related services, you agree to this Policy.",
        "p-h2-1": "1. How We Collect and Use Your Personal Information",
        "p-p-1-1": "We adhere to the principles of legitimacy, legality, and necessity when collecting and using your voluntarily provided personal information for the following functions and services during your use of our products (or services).",
        "p-p-1-2": "This application cannot and will not collect additional personal information from you.",
        "p-h3-1": "1.1 Account",
        "p-p-1-3": "\"Account\" refers to the account you may need to use ClashNEXT APP in the future. When you log in, based on our cooperation with Huawei, we will collect your 【Huawei Account】 to provide you with quick login services.",
        "p-p-1-4": "We follow the principle of data minimization, collecting only necessary user nickname, avatar, UnionID, and OpenID from 【Huawei Account】 for display, VIP benefits distribution, and cloud backup services. We will never access or collect sensitive personal information such as phone numbers, ensuring the security of your account information.",
        "p-p-1-5": "You can use all free basic features of this application without logging in. In this state, all user data will be stored locally on the device and managed by you.",
        "p-h3-2": "1.2 Synchronizing Task Data",
        "p-p-2-1": "If you register an account, create settings data, and require synchronization services, we will collect your application settings, proxy configurations, override settings, and device information related to editing operations (including device model, OS version, unique device identifier, and device display status) to enable normal and complete data synchronization across devices. We cannot and will not read the content of your data.",
        "p-h3-3": "1.3 Submitting Feedback",
        "p-p-3-1": "When you submit feedback to ClashNEXT, we may collect Log files, device model, and OS version to accurately understand and resolve the issues you report.",
        "p-h3-4": "1.4 Permissions Requested in the App",
        "p-p-4-1": "We request certain system permissions involving personal privacy to ensure normal functionality. We will seek your authorization before accessing your personal information. You may decline authorization if you do not need these features. If you never use these features, we will neither request permissions nor access your personal information. The permissions and their purposes include:",
        "p-p-4-2": "Camera permission: Required when you need to import configurations by taking photos or scanning QR codes. After authorization, you can use the camera to add images to tasks or scan QR codes.",
        "p-p-4-3": "Multi-device collaboration permission: Required when you need to synchronize data across devices.",
        "p-p-4-4": "Notification permission: Required for background task execution.",
        "p-h3-5": "1.5 Other Purposes",
        "p-p-5-1": "We will seek your consent in advance if we need to use your information for purposes not specified in this Policy or repurpose information collected for specific objectives.",
        "p-h2-2": "2. Your Rights to Manage Personal Information",
        "p-p-2-2": "We strive to protect your rights to access, correct, and delete your personal information, empowering you to safeguard your privacy and security.",
        "p-h2-3": "3. Protection of Children",
        "p-p-3-2": "Our products and services are intended for adults only.",
        "p-h2-4": "4. Third-Party SDKs",
        "p-p-4-5": "We conduct strict security checks on SDKs and similar applications, requiring partners to implement stringent measures to protect your personal data. When new service requirements or functional changes arise, we may adjust integrated third-party SDKs and promptly update this document. Please note that third-party SDKs may modify data types due to version updates or policy adjustments. Refer to their official documentation for the latest details. For integrated third-party SDKs, please check \"Third-Party Libraries and Services.\"",
        "p-h2-5": "5. Policy Updates",
        "p-p-5-2": "As this Privacy Policy may be updated periodically, please review it regularly to stay informed about how we protect your personal information. Your continued use of ClashNEXT services constitutes acceptance of this Policy and its updates. For significant changes, we may provide prominent notices describing specific updates. Significant changes include but are not limited to:",
        "p-p-5-3": "Major changes to our service model (e.g., collecting personal information).",
        "p-p-5-4": "Major changes to your rights regarding personal information processing.",
        "p-p-5-5": "High risks identified in personal information security impact assessments.",
        "p-p-5-6": "Changes to the department, contact methods, or complaint channels responsible for handling feedback.",
        "p-h2-6": "6. Contact Us",
        "p-p-6-1": "If you have questions, comments, or suggestions about this Privacy Policy, contact us via:",
        "p-p-6-2": "Email:",
        "p-p-6-3": "xfz347@gmail.com",
        "p-p-6-4": "Join QQ Group:",
        "p-p-6-5": "693903194",
        "p-h2-7": "Developer: Xiaobai Studio",
        "p-h2-8": "App Name: ClashNEXT"
    },
    'zh-TW': {
      //  "u-main-title": "使用者條款",
        "u-sub-title": "更新日期：2025年5月1日",
        "u-sub-title-2": "ClashNEXT的所有權與營運權歸小白工坊所有。在本服務條款中簡稱\"本工坊\"或稱為\"我們\"。使用ClashNEXT產品及服務將視為您同意以下使用條款。",
        "u-h2-1": "1. 僅供個人使用",
        "u-p-1": "ClashNEXT僅供使用者個人用於學習交流、科研等非商業用途。禁止私自將ClashNEXT或與ClashNEXT有關或衍生之任何資料、服務或軟體用於商業目的。若使用者對ClashNEXT有任何意見或改進建議，可向我們提出。請注意，此舉將授予ClashNEXT及第三方在ClashNEXT（或第三方軟體）中無償使用並加入使用者建議或意見之權利。",
        "u-h2-2": "2. 智慧財產權",
        "u-p-2": "使用者承認本團隊擁有ClashNEXT之所有權利，包含但不限於所有智慧財產權。「智慧財產權」係指專利法、著作權法、營業秘密法、商標法、公平交易法等法規所規範之所有權利，以及其應用、更新、擴展與恢復，無論現行或未來於全球範圍內生效。使用者同意不透過反編譯、反向工程、反組譯或其他方式自ClashNEXT取得原始碼。使用者可透過ClashNEXT開源儲存庫取得核心原始碼，並同意不刪除、遮蔽或變更本團隊或第三方之著作權聲明、商標或其他所有權標示。",
        "u-h2-3": "3. 使用者隱私權政策",
        "u-p-3-1": "尊重使用者個人隱私是本團隊基本政策。基此原則，本團隊通常不會公開、編輯或揭露使用者註冊資料或儲存於服務中之非公開內容，惟於誠信原則下遇下列情形時除外：",
        "u-3-li-1": "遵守相關法律規定，包含司法機關要求提供使用者透過ClashNEXT發佈之資訊內容、發佈時間、IP位址或網域名稱時。",
        "u-3-li-2": "為維護本團隊商標等智慧財產權所需。",
        "u-3-li-3": "緊急情況下為保障使用者個人及公眾隱私安全。",
        "u-3-li-4": "其他本團隊認定有必要之情形。",
        "u-p-3-2": "本政策說明當您使用ClashNEXT相關服務時，我們如何處理您的個人資料及保護隱私權。您同意於遵守ClashNEXT隱私權政策之前提下使用自身資料。",
        "u-h2-4": "4. 服務變更",
        "u-p-4": "本團隊保留隨時變更、中斷或終止服務而無須另行通知之權利。使用者同意本團隊行使此權利，本團隊無須對使用者或第三方負擔任何責任。",
        "u-h2-5": "5. 責任限制",
        "u-p-5-1": "使用者理解並同意自行承擔下載及使用ClashNEXT與其附帶第三方軟體之風險，對於因此導致之系統損壞或資料遺失應負全責。於適用法律允許之最大範圍內，本團隊明確聲明不提供任何明示或默示保證，包含但不限於適售性、適用性、可靠性、正確性、完整性、無病毒或無錯誤等。",
        "u-p-5-2": "於適用法律允許之最大範圍內，本團隊及其授權方不提供以下保證：",
        "u-li-5-1": "服務將完全符合使用者需求；",
        "u-li-5-2": "服務使用過程將持續不中斷、及時、安全或無錯誤；",
        "u-li-5-3": "透過服務取得之資訊必然準確可靠；",
        "u-p-5-3": "隨服務提供之軟體操作瑕疵將獲得修正。",
        "u-p-5-4": "於適用法律允許之最大範圍內，本團隊不就使用者使用ClashNEXT所衍生之任何直接、間接、偶發、特殊或附帶損害（包括但不限於人身傷害、隱私外洩、違反誠信責任、過失所致之金錢損失）承擔責任。",
        "u-h2-6": "6. 保障",
        "u-p-6": "使用者同意負擔因違反本條款所致之律師費、損害賠償、政府罰鍰及其他侵權賠償費用，以維護本團隊權益。",
        "u-h2-7": "7. 法律",
        "u-p-7-1": "本條款依中華人民共和國法律解釋。如有爭議，雙方同意由當地法院管轄。如有疑問，請透過以下方式聯繫：",
        "u-p-7-2": "電子郵件：",
        "u-p-7-3": "xfz347@gmail.com",
        "u-p-7-4": "加入QQ群組：",
        "u-p-7-5": "693903194",
        "u-h2-8": "開發者：小白工坊",
        "u-h2-9": "應用程式名稱：ClashNEXT",
    //    "p-main-title": "關於ClashNEXT與隱私權的聲明",
        "p-sub-title": "更新日期：2025年5月11日",
        "p-sub-title-1": "本政策僅適用於本工坊（以下簡稱「我們」）之產品「ClashNEXT」及其相關服務。",
        "p-sub-title-2": "您的個人資料安全對我們至關重要，我們始終致力於保護您的個人資料安全並維持您的信任。我們將依據相關法令及技術規範收集與使用您的個人資料，以提供更優質的產品與服務。同時，我們承諾嚴格保密您的個人資料與其他數據，確保其安全性。",
        "p-sub-title-3": "請於使用我們的產品與服務前，詳細閱讀本隱私權政策（以下簡稱「本政策」）。一旦開始使用ClashNEXT產品及相關服務，即視為您同意本政策。",
        "p-h2-1": "1. 我們如何收集與使用您的個人資料",
        "p-p-1-1": "我們遵循正當性、合法性與必要性原則，基於下列功能與服務，收集並使用您於使用產品（或服務）過程中主動提供之個人資料。",
        "p-p-1-2": "本應用程式無法且不會額外蒐集您的個人資料",
        "p-h3-1": "1.1 帳號",
        "p-p-1-3": "「帳號」指您使用ClashNEXT APP時可能需要的帳戶。當您登入時，基於與華為之合作，我們將蒐集您的【華為帳號】，以便提供快捷登入服務。",
        "p-p-1-4": "我們遵循資料最小化原則，僅取得【華為帳號】中必要之使用者暱稱、頭像、UnionID及OpenID，用於顯示、發放VIP權益與雲端備份服務，全程不會接觸或蒐集手機號碼等敏感性個人資料，確保帳號資訊安全。",
        "p-p-1-5": "使用者可於未登入狀態下正常使用本應用程式所有免費基礎功能。此狀態下所有資料僅儲存於裝置本地，由使用者自行管理。",
        "p-h3-2": "1.2 同步任務資料",
        "p-p-2-1": "當您註冊帳號並於帳號中創建設定等資料，且需使用同步服務時，為使您完整跨裝置同步資料，您需允許我們蒐集應用設定、代理配置、覆寫設定，以及編輯操作時之裝置資訊（包含：裝置型號、作業系統版本、唯一裝置識別碼、裝置顯示狀態）。此類資料僅用於同步功能，我們無法讀取資料內容。",
        "p-h3-3": "1.3 提交意見回饋",
        "p-p-3-1": "您提交意見回饋時，為準確理解問題，我們可能蒐集Log檔案、裝置型號、作業系統版本等資訊。",
        "p-h3-4": "1.4 應用程式申請之權限",
        "p-p-4-1": "我們需申請涉及隱私權之系統權限，以確保特定功能正常運作。僅於您使用相關功能時請求授權，未經授權不會存取資料。若您未使用相關功能，我們不會主動申請權限。申請權限及對應功能如下：",
        "p-p-4-2": "允許相機權限：當您需拍攝照片或掃描QR碼匯入設定時，將請求此權限；",
        "p-p-4-3": "允許多裝置協同權限：當需同步跨裝置資料時，將請求此權限；",
        "p-p-4-4": "允許通知權限：當需背景執行任務時，將請求此權限。",
        "p-h3-5": "1.5 其他用途說明",
        "p-p-5-1": "若需將資料用於本政策未載明之用途，我們將事先取得您同意。基於特定目的蒐集之資料用於其他目的時，亦會事先徵得同意。",
        "p-h2-2": "2. 您管理個人資料之權利",
        "p-p-2-2": "我們全力保障您存取、更正及刪除個人資料之權利，以維護您的隱私與安全。",
        "p-h2-3": "3. 兒童保護",
        "p-p-3-2": "本產品與服務僅提供予成年人使用。",
        "p-h2-4": "4. 第三方SDK",
        "p-p-4-5": "我們對第三方SDK進行嚴格安全審查，要求合作方遵循資料保護規範。因應服務調整，我們可能變更接入之SDK，並於本說明中公告更新情形。第三方SDK可能因版本更新調整資料類型，請以其官方公告為準。已接入之第三方SDK清單請至三方函式庫與服務查閱。",
        "p-h2-5": "5. 政策更新方式",
        "p-p-5-2": "本隱私權政策可能不定期更新，建議您定期查閱以了解最新個人資料保護措施。繼續使用ClashNEXT服務即視為同意修訂後政策。重大變更將以顯著方式通知，包含但不限於：",
        "p-p-5-3": "服務模式重大變更（如新增個人資料蒐集項目）；",
        "p-p-5-4": "您行使個人資料權利之方式重大調整；",
        "p-p-5-5": "個資安全影響評估顯示高風險時；",
        "p-p-5-6": "負責處理個資之部門、聯絡管道或申訴途徑變更時；",
        "p-h2-6": "6. 聯絡方式",
        "p-p-6-1": "若對本隱私權政策有任何疑問或建議，請透過以下方式聯絡：",
        "p-p-6-2": "電子郵件：",
        "p-p-6-3": "xfz347@gmail.com",
        "p-p-6-4": "加入QQ群組：",
        "p-p-6-5": "693903194",
        "p-h2-7": "開發者：小白工坊",
        "p-h2-8": "應用程式名稱：ClashNEXT"
    },
    'zh-HK': {
     //   "u-main-title": "用戶協議",
        "u-sub-title": "更新日期：2025年5月1日",
        "u-sub-title-2": "ClashNEXT嘅所有權同運作權歸小白工坊所有。喺本服務條款中簡稱\"本工坊\"或稱為\"我哋\"。使用ClashNEXT產品及服務將視為您同意以下使用條款。",
        "u-h2-1": "1. 僅供個人使用",
        "u-p-1": "ClashNEXT僅供用戶個人用於學習交流、科研等非商業用途。禁止私自將ClashNEXT或與ClashNEXT有關或派生嘅任何資料、服務或軟件用於商業目的。如果用戶對ClashNEXT有任何意見，或有如何改進嘅建議，可向我哋提出。請注意，如果咁樣做，仲會授予ClashNEXT同第三方喺ClashNEXT（或第三方軟件）中無償使用同加入用戶嘅建議或意見嘅權利。",
        "u-h2-2": "2. 知識產權",
        "u-p-2": "用戶承認本團隊擁有對ClashNEXT嘅所有權利，包括但不限於所有知識產權。「知識產權」指喺專利法、版權法、商業機密法、商標法、反不正當競爭法等法中規定嘅所有權利以及其中嘅所有應用、更新、擴展同恢復，無論現時或日後喺全球範圍內實施及生效。用戶同意唔會透過反編譯、反向工程、反彙編等方式從ClashNEXT取得源代碼。用戶可透過ClashNEXT開源倉庫獲取核心源代碼，並同意唔會刪除、掩蓋或更改本團隊或任何第三方嘅版權聲明、商標或其他所有權聲明。",
        "u-h2-3": "3. 用戶私隱制度",
        "u-p-3-1": "尊重用戶個人私隱係本團隊嘅一項基本政策。所以，本團隊一般唔會公開、編輯或透露用戶嘅註冊資料或保存喺本團隊服務中嘅非公開內容，除非本團隊誠信基礎上認為透露呢啲信息喺以下幾種情況係必要嘅：",
        "u-3-li-1": "遵守有關法律規定，包括喺國家有關機關查詢時，提供用戶通過ClashNEXT發佈嘅信息內容及其發佈時間、互聯網地址或者域名。遵從ClashNEXT嘅服務程序。",
        "u-3-li-2": "保持維護本團隊嘅商標等知識產權。",
        "u-3-li-3": "喺緊急情況下竭力維護用戶個人同社會大眾嘅私隱安全。",
        "u-3-li-4": "本團隊認為必要嘅其他情況下。",
        "u-p-3-2": "該政策解釋咗當您使用ClashNEXT相關嘅服務時，ClashNEXT會點樣處理您嘅個人信息，以及點樣保護您嘅私隱權。您同意會喺遵守ClashNEXT私隱權政策嘅前提下應用自己嘅數據。",
        "u-h2-4": "4. 服務變更",
        "u-p-4": "本團隊保留隨時變更、中斷或終止服務而唔需通知用戶嘅權利。用戶接受本團隊行使變更、中斷或終止服務嘅權利，本團隊唔需對用戶或第三方負責。",
        "u-h2-5": "5. 責任限制",
        "u-p-5-1": "用戶理解並同意自主選擇下載同使用ClashNEXT同所有與ClashNEXT一齊提供或通過ClashNEXT提供嘅第三方軟件，風險自負，並且對於因下載或使用ClashNEXT同此類第三方軟件而對電腦系統造成嘅損壞或數據嘅丟失，用戶應承擔全部責任。在適用法律允許嘅最大範圍內，本團隊明確表示唔提供任何其他類型嘅保證，不論使明示嘅或默示嘅，包括但不限於適銷性、適用性、可靠性、準確性、完整性、無病毒以及無錯誤嘅任何默示保證同責任。",
        "u-p-5-2": "在適用法律允許嘅最大範圍內，本團隊及其許可人唔會向您做出以下聲明或擔保：",
        "u-li-5-1": "您對服務嘅使用會滿足您嘅需求；",
        "u-li-5-2": "您對服務嘅使用會連續無中斷、及時、安全或冇錯誤；",
        "u-li-5-3": "您使用相關服務而獲得嘅任何信息一律準確可靠；",
        "u-p-5-3": "作為相關服務嘅一部分向您提供嘅任何軟件所發生嘅操作或功能瑕疵將獲得修正。",
        "u-p-5-4": "在適用法律允許嘅最大範圍內，本團隊唔會就因用戶使用ClashNEXT引起嘅，或在任何方面與本團隊嘅產品和服務有關嘅任何意外嘅、非直接嘅、特殊嘅、或間接嘅損害或請求（包括但不限於因人身傷害、因私隱洩漏、因未能履行包括誠信或合理謹慎在內嘅任何責任、因過失同因任何其他金錢上嘅損失或其他損失而造成嘅損害賠償）承擔任何責任。",
        "u-h2-6": "6. 保障",
        "u-p-6": "用戶同意保障同維護本團隊嘅利益，負責支付由用戶違反本服務條款或本團隊其他服務條款而引起嘅律師費用、損害補償費用、政府機關處罰費用同其他侵權賠償費用等。",
        "u-h2-7": "7. 法律",
        "u-p-7-1": "上述條款將受中華人民共和國法律嘅約束並依據其解釋。如出現糾紛，用戶同本團隊一致同意將糾紛交由當地人民法院管轄。如用戶對本服務條款內容有任何疑問，通過以下方式聯繫我哋：",
        "u-p-7-2": "發送郵件到：",
        "u-p-7-3": "xfz347@gmail.com",
        "u-p-7-4": "加入QQ交流群：",
        "u-p-7-5": "693903194",
        "u-h2-8": "開發者：小白工坊",
        "u-h2-9": "應用名稱：ClashNEXT",
       // "p-main-title": "關於ClashNEXT與私隱嘅聲明",
        "p-sub-title": "更新日期：2025年5月11日",
        "p-sub-title-1": "本政策僅適用於本工坊（以下簡稱「我哋」）嘅產品「ClashNEXT」及其相關服務。",
        "p-sub-title-2": "您嘅個人資料安全對我哋嚟講至關重要，一直以嚟，我哋都盡全力保護您嘅個人資料安全，致力於維持您對我哋嘅信任。我哋會依據相關法律法規同技術規範收集同使用您嘅個人資料，以幫助我哋向您提供更優質嘅產品同服務。同時，我哋承諾會對您嘅個人資料同其他數據進行嚴格保密，確保您嘅個人資料安全。",
        "p-sub-title-3": "請喺使用我哋嘅產品同服務前，仔細閱讀本私隱政策（以下簡稱「本政策」）。一旦您開始使用ClashNEXT產品及相關服務，即表示您同意本政策。",
        "p-h2-1": "1. 我哋點樣收集同使用您嘅個人資料",
        "p-p-1-1": "我哋會遵循正當、合法、必要嘅原則，基於以下功能同服務，收集同使用您喺使用產品（或服務）過程中自願提供嘅個人資料。",
        "p-p-1-2": "本應用無法亦唔會額外收集您嘅個人資料",
        "p-h3-1": "1.1 帳號",
        "p-p-1-3": "「帳號」指您喺使用ClashNEXT APP時將來可能會需要嘅帳號。當您登錄時，基於我哋同華為嘅合作，我哋會收集您嘅【華為帳戶】，以便為您提供快捷嘅登錄服務。",
        "p-p-1-4": "我哋遵循數據最小化原則，僅獲取【華為帳戶】中必要嘅用戶暱稱、頭像、UnionID同OpenID，用於展示、發放VIP權益及雲端備份服務，全程唔會接觸或收集用戶嘅手機號碼等敏感個人資料，切實保障用戶帳號信息安全。",
        "p-p-1-5": "用戶可喺唔登錄嘅狀態下正常使用本應用嘅所有免費基礎功能。喺該狀態下，所有用戶數據將僅儲存喺設備本地，由用戶自行管理。",
        "p-h3-2": "1.2 同步任務數據",
        "p-p-2-1": "當您註冊帳號並喺帳號中創建設定等數據，且需要使用同步服務時，為使您正常、完整地喺各設備間同步數據，您需要允許我哋收集您嘅應用設定、代理配置、覆寫設定、您進行編輯操作嘅設備信息（包括：設備型號、操作系統版本、唯一設備識別碼、設備顯示狀態）。以上資料僅用於您喺各設備間同步數據，我哋唔會亦無法讀取您嘅數據內容。",
        "p-h3-3": "1.3 提交反饋",
        "p-p-3-1": "您向ClashNEXT提交反饋時，為確保我哋能準確理解並篩查您遇到嘅問題，我哋可能會收集嘅資料包括：Log files、設備型號、操作系統版本。",
        "p-h3-4": "1.4 應用內會申請嘅權限",
        "p-p-4-1": "我哋需要申請部分涉及個人私隱嘅系統權限，確保應用內某些功能可以正常使用。我哋會喺您使用呢啲功能時，向您申請授權，明確獲得您嘅授權後，我哋先會存取您嘅個人資料。若您唔需要使用呢啲功能，可以拒絕授權；若您從未使用過呢啲功能，我哋唔會向您申請權限、亦唔會存取您嘅個人資料。我哋會申請嘅權限及呢啲權限對應嘅功能包括：",
        "p-p-4-2": "允許相機權限：當您需要透過拍攝照片或掃描二維碼導入配置時，我哋會申請此權限。獲得授權後，您可以使用相機功能添加圖片至待辦事項或快速掃碼；",
        "p-p-4-3": "允許多設備協同權限：當應用可以實現且您需要同步設備間數據時，我哋會申請此權限；",
        "p-p-4-4": "允許通知權限：當您需要後台運行任務時，我哋會申請此權限。",
        "p-h3-5": "1.5 其他用途說明",
        "p-p-5-1": "當我哋需要將您嘅資料用於本政策未說明嘅其他用途時，會事先徵求您嘅同意。當我哋需要將基於特定目的收集嘅資料用於其他目的時，會事先徵求您嘅同意。",
        "p-h2-2": "2. 您管理個人資料嘅權利",
        "p-p-2-2": "我哋盡全力保護您對於自己個人資料嘅存取、更正以及刪除嘅權利，以使您擁有充分能力保障您嘅私隱同安全。",
        "p-h2-3": "3. 對兒童嘅保護",
        "p-p-3-2": "我哋嘅產品同服務僅面向成人。",
        "p-h2-4": "4. 第三方SDK",
        "p-p-4-5": "我哋會對 SDK 或其他類似應用程式進行嚴格嘅安全檢測，並要求合作夥伴採取嚴格措施保護您嘅個人數據。喺滿足新服務需求及業務功能變更時，我哋可能會調整我哋接入嘅第三方 SDK，並及時喺本說明中向您公開說明接入第三方 SDK 嘅最新情況。請注意，第三方SDK 可能因版本升級、策略調整等原因導致數據類型存在變化，請以其公示嘅官方說明為準。本應用已接入嘅第三方SDK請前往三方庫與服務中查看。",
        "p-h2-5": "5. 本政策如何更新",
        "p-p-5-2": "由於本私隱政策可能不定時更新，您應定期查看以了解我哋保護所收集之個人資料嘅方案及程序。您繼續使用ClashNEXT服務即構成您對本私隱政策及其任何更新版本嘅同意。對於重大變更，視具體情況我哋可能還會提供更顯著嘅通知說明本政策嘅具體變更內容。重大變更包括但不限於：",
        "p-p-5-3": "我哋嘅服務模式發生重大變化。如申請收集個人資料等；",
        "p-p-5-4": "您參與個人資料處理方面嘅權利及其行使方式發生重大變化；",
        "p-p-5-5": "個人資料安全影響評估報告表明存在高風險時；",
        "p-p-5-6": "我哋負責處理反饋信息嘅責任部門、聯絡方式及投訴渠道發生變化時；",
        "p-h2-6": "6. 如何聯繫我哋",
        "p-p-6-1": "如果您對本私隱政策有任何疑問、意見或建議，透過以下方式聯繫我哋：",
        "p-p-6-2": "發送郵件到：",
        "p-p-6-3": "xfz347@gmail.com",
        "p-p-6-4": "加入QQ交流群：",
        "p-p-6-5": "693903194",
        "p-h2-7": "開發者：小白工坊",
        "p-h2-8": "應用名稱：ClashNEXT"
    }
};


